unit BitmapMenu;

//  ,       Bitmap
//     . (. Shape  Color).

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    ShapeDemo: TShape;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    MenuShape: TMenuItem;
    Ellipse1: TMenuItem;
    RoundRec1: TMenuItem;
    Rectang1: TMenuItem;
    MenuColor: TMenuItem;
    Red1: TMenuItem;
    Green1: TMenuItem;
    Blue1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    LabelTitle: TLabel;
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Red1Click(Sender: TObject);
    procedure Green1Click(Sender: TObject);
    procedure Blue1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Ellipse1Click(Sender: TObject);
    procedure RoundRec1Click(Sender: TObject);
    procedure Rectang1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//  BitMap  Items   MenuShape  MenuColor
procedure BitMapFigure (RqBitMap : TBitmap;
                        RqFigure : Byte;
                        RqColor  : TColor;
                        RqText   : string);
const BMW = 100; //  BitMap
      BMH = 16;  //  BitMap
      TX  = 30;  //   
var   R : TRect;
begin
   //   BitMap
   RqBitMap.Width  := BMW;
   RqBitMap.Height := BMH;
   //      BitMap
   RqBitMap.Canvas.Font.Size := 8;
   RqBitMap.Canvas.Font.Color := clBlack;
   //  BitMap
   R := Rect(0,0,BMW ,BMH);
   RqBitMap.Canvas.Brush.Color := clBtnFace;
   RqBitMap.Canvas.FillRect(R);
   //      BitMap
   R := Rect(2,2,TX - 2,BMH - 2);
   RqBitMap.Canvas.Brush.Color := RqColor;
   RqBitMap.Canvas.Brush.Style := bsSolid;
   case RqFigure of
   0 : begin
         RqBitMap.Canvas.Ellipse(R);
         RqBitMap.Canvas.Brush.Color := clBtnFace;
         RqBitMap.Canvas.TextOut(TX + 2,2,'Ellipse');
      end;
   1 : begin
         RqBitMap.Canvas.RoundRect(R.Left, R.Top, R.Right, R.Bottom, 5,5);
         RqBitMap.Canvas.Brush.Color := clBtnFace;
         RqBitMap.Canvas.TextOut(TX + 2,2,'RoundRect');
       end;
   2 : begin
         RqBitMap.Canvas.Rectangle(R);
         RqBitMap.Canvas.Brush.Color := clBtnFace;
         RqBitMap.Canvas.TextOut(TX + 2,2,'Rectangle');
       end;
       else begin
         RqBitMap.Canvas.Rectangle(R);
         RqBitMap.Canvas.Brush.Color := clBtnFace;
         RqBitMap.Canvas.TextOut(TX + 2,2,RqText);
       end;
   end; // case
end;

// ,    BitMap  Items  MenuShape  MenuColor
procedure TForm1.FormCreate(Sender: TObject);
var
  Ind : Integer;
  Bmp : TBitmap;   //    Bitmap
begin
  // ,    BitMap  Items  MenuShape
  for Ind := 0 to MenuShape.Count - 1 do
  begin
    Bmp := TBitmap.Create;
    BitMapFigure(Bmp, Ind, clSilver, '');
    //  ( )  BitMap
    // Bmp.LoadFromFile ('.\MenuImage\'
    //                   + Shape1.Items[Ind].Caption
    //                   + '.bmp');
    // ------------------------------------------------------
    //  BitMap   Item
    // function ModifyMenu; external user32 name 'ModifyMenuA';
    ModifyMenu (MenuShape.Handle,
                MenuShape.Items[Ind].MenuIndex,
                mf_ByPosition or mf_Bitmap,
                MenuShape.Items[Ind].Command,
                Pointer(Bmp.Handle));
    //    BitMap   Free
    MenuShape.Items[Ind].Tag := Integer(Bmp);
  end;
  // ,    BitMap  Items  MenuColor
  for Ind := 0 to MenuColor.Count - 1 do
  begin
    //    BitMap   Item
    Bmp := TBitmap.Create;
    case Ind of
     0 : BitMapFigure(Bmp, 3, clRed,  'Red');
     1 : BitMapFigure(Bmp, 3, clLime, 'Green');
     2 : BitMapFigure(Bmp, 3, clBlue, 'Blue');
    end;
    //  ( )  BitMap
    // Bmp.LoadFromFile ('.\MenuImage\'
    //                    + Color1.Items[Ind].Caption
    //                    + '.bmp');
    // ------------------------------------------------------
    //  BitMap   Item
    // function ModifyMenu; external user32 name 'ModifyMenuA';
    ModifyMenu (MenuColor.Handle,
                MenuColor.Items[Ind].MenuIndex,
                mf_ByPosition or mf_Bitmap,
                MenuColor.Items[Ind].Command,
                Pointer (Bmp.Handle));
    //    BitMap   Free
    MenuColor.Items[Ind].Tag := Integer(Bmp);
  end;
end;

//   BitMap 
procedure TForm1.FormDestroy(Sender: TObject);
var
  Ind : Integer;
begin
  for Ind := 0 to MenuShape.Count - 1 do
      TBitmap(MenuShape.Items[Ind].Tag).Free;
  for Ind := 0 to MenuColor.Count - 1 do
      TBitmap(MenuColor.Items[Ind].Tag).Free;
end;

//    Items  MenuShape
procedure TForm1.Ellipse1Click(Sender: TObject);
begin
  ShapeDemo.Shape := stEllipse;
end;
procedure TForm1.RoundRec1Click(Sender: TObject);
begin
  ShapeDemo.Shape := stRoundRect;
end;
procedure TForm1.Rectang1Click(Sender: TObject);
begin
  ShapeDemo.Shape := stRectangle;
end;

//    Items   MenuColor
procedure TForm1.Red1Click(Sender: TObject);
begin
  ShapeDemo.Brush.Color := clRed;
end;
procedure TForm1.Green1Click(Sender: TObject);
begin
  ShapeDemo.Brush.Color := clLime;
end;
procedure TForm1.Blue1Click(Sender: TObject);
begin
  ShapeDemo.Brush.Color := clBlue;
end;

// 
procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

// About
procedure TForm1.About1Click(Sender: TObject);
begin
  MessageDlg (' Bitmap Menu,'#13 +
    '(   )',
    mtInformation, [mbOK], 0);
end;

end.
